---
title: AI Face Swap API Usage Guide
slug: eC4eIgRJKwIGIsmMqAH4l
createdAt: Thu Jul 18 2024 06:04:57 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:43:11 GMT+0000 (Coordinated Universal Time)
---

# AI Face Swap API Usage Guide

## Introduction

This document will guide developers on how to use the aonet library to call the AI Face Swap API.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure that the aonet library is installed. If it is not installed yet, you can install it using npm:

```bash
npm install aonet
```

## Steps to Use

### 1. Import the aonet library

```js
const AI = require("aonet");
```

### 2. Configure Options

Create an options object that includes your APPID:

```js
const options = {
    appid: "your APPID"
};
```

Make sure to replace "your APPID" with your actual Aonet APPID.

### 3. Initialize AI Instance

Initialize the AI instance using the configuration options:

```js
const aonet = new AI(options);
```

### 4. Call the Face Swap API

Use the `prediction` method to call the Face Swap API:

```js
async function performFaceSwap() {
    try {
        let response = await aonet.prediction("/predictions/ai/face-swap",
        {
            input: {
                "swap_image": "https://aonet.ai/pbxt/JoBuzfSVFLb5lBqkf3v9xMnqx3jFCYhM5JcVInFFwab8sLg0/long-trench-coat.png",
                "target_image": "https://replicate.delivery/pbxt/JoBuz3wGiVFQ1TDEcsGZbYcNh0bHpvwOi32T1fmxhRujqcu7/9X2.png"
            }
        });
        console.log("Face swap result:", response);
    } catch (error) {
        console.error("Error performing face swap:", error);
    }
}

performFaceSwap();
```

### Parameter Description

- `swap_image`: URL of the image containing the face to be swapped.
- `target_image`: URL of the target image where the face will be swapped.

### Notes

- Ensure that the provided image URLs are publicly accessible.
- The API may take some time to process the images, consider implementing appropriate wait or retry logic.
- Handle possible errors, such as network issues or API limitations.

### Example Response

The API response will contain the URL of the processed image or other relevant information. Parse and use the response data according to the actual API documentation.

## Advanced Usage

- Consider implementing error retry mechanisms.
- Add image validation logic to ensure the provided URLs point to valid image files.
- For production environments, consider implementing rate limiting and caching mechanisms to optimize API usage.

